//

// Fragment shader for Push transition
//
// Author: Jeff Brown
//

uniform sampler2DRect texUnit;
uniform sampler2DRect inTexUnit;
uniform sampler2DRect outTexUnit;

uniform vec4 textureRect;
uniform vec4 textureRect2;

uniform int hasTextureIn;  // 0 = no texture in, 1 = has texture in 
uniform int hasTextureOut;  // 0 = no texture in, 1 = has texture in 
uniform float inAlphaValue; 
uniform float outAlphaValue; 
uniform int isScreenRendered; // 0 - NO, 1 - YES
uniform float clearScreenR; 
uniform float clearScreenG; 
uniform float clearScreenB; 
uniform float clearScreenA; 

uniform float modTex0;
uniform float modTex1;
uniform float modScreen;
uniform int mode;
uniform  vec4 modulateColor;
varying vec2 gUV;
varying vec2 gUV2; 
const float kSmallValue = 1.0e-3; 

void main(void)
{
	if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else
    {
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w;
        
        if(mode==0)
        {
            vec4 outputColor;
            vec4 red,green,blue;
            vec2 tmp;

            float seam;
            seam=textureWidth*inAlphaValue;

            if(gUV.x>=seam)
            {
                tmp=gUV;
                tmp.x-=seam;
                outputColor=texture2DRect(outTexUnit,tmp);
                outputColor*=modTex1;
            }
            else
            {
                tmp=gUV2;
                tmp.x+=(textureWidth-seam);
                outputColor=texture2DRect(inTexUnit,tmp);
                outputColor*=modTex0;
            }
            gl_FragColor = outputColor;
        }
        else if(mode==1)
        {
            vec4 outputColor;
            vec2 tmp;
            
            float seam=textureWidth-textureWidth*inAlphaValue;
            if(gUV.x<=seam)
            {
                tmp=gUV;
                tmp.x+=(textureWidth-seam);
                outputColor=texture2DRect(outTexUnit,tmp);
                outputColor*=modTex1;
            }
            else
            {
                tmp=gUV2;
                tmp.x-=seam;
                outputColor=texture2DRect(inTexUnit,tmp);
                outputColor*=modTex0;
            }
            gl_FragColor = outputColor;
        }
        else if(mode==2)
        {
            vec4 outputColor;
            vec2 tmp;
            
            float seam=textureHeight*inAlphaValue;
            if(gUV.y>=seam)
            {
                tmp=gUV;
                tmp.y-=seam;
                outputColor=texture2DRect(outTexUnit,tmp);
                outputColor*=modTex1;
            }
            else
            {
                tmp=gUV2;
                tmp.y+=(textureHeight-seam);
                outputColor=texture2DRect(inTexUnit,tmp);
                outputColor*=modTex0;
            }
            gl_FragColor = outputColor;
        }
        else
        {
            vec4 outputColor;
            vec2 tmp;
            
            float seam=textureHeight-textureHeight*inAlphaValue;
            if(gUV.y<=seam)
            {
                tmp=gUV;
                tmp.y+=(textureHeight-seam);
                outputColor=texture2DRect(outTexUnit,tmp);
                outputColor*=modTex1;
            }
            else
            {
                tmp=gUV2;
                tmp.y-=seam;
                outputColor=texture2DRect(inTexUnit,tmp);
                outputColor*=modTex0;
            }
            gl_FragColor = outputColor;
        }
    }
}


